
uniform sampler2D u_texture;
uniform sampler2D u_textureTarget;
uniform mediump vec4 u_uvTargetTransform;
uniform mediump float u_sourceOverBurn;
uniform mediump float u_targetConstantFactor;
uniform mediump float u_targetInverseSourceFactor;
uniform mediump float u_power;

varying lowp vec4 v_fragmentColor;
varying highp vec2 v_texCoord;

void main()
{
	mediump vec4 sourceColor = v_fragmentColor * texture2D(u_texture, v_texCoord);
	mediump vec4 targetColor = texture2D(u_textureTarget, v_texCoord * u_uvTargetTransform.xy + u_uvTargetTransform.zw);
	mediump vec4 blendedColor = sourceColor * (1 + u_sourceOverBurn) + targetColor * (u_targetConstantFactor + (1 - sourceColor) * u_targetInverseSourceFactor);
	gl_FragColor = vec4(pow(blendedColor.xyz, vec3(u_power)), blendedColor.w);
}
